<?php

namespace TablePress\PhpOffice\PhpSpreadsheet\Calculation\LookupRef;

use TablePress\PhpOffice\PhpSpreadsheet\Calculation\Functions;
use TablePress\PhpOffice\PhpSpreadsheet\Calculation\Information\ExcelError;
use TablePress\PhpOffice\PhpSpreadsheet\Cell\Cell;
use TablePress\PhpOffice\PhpSpreadsheet\Shared\StringHelper;

class Hyperlink
{
	/**
	 * HYPERLINK.
	 *
	 * Excel Function:
	 *        =HYPERLINK(linkURL, [displayName])
	 *
	 * @param mixed $linkURL Expect string. Value to check, is also the value returned when no error
	 * @param mixed $displayName Expect string. Value to return when testValue is an error condition
	 * @param ?Cell $cell The cell to set the hyperlink in
	 *
	 * @return string The value of $displayName (or $linkURL if $displayName was blank)
	 */
	public static function set($linkURL = '', $displayName = null, ?Cell $cell = null): string
	{
		$worksheet = null;
		$coordinate = '';
		if ($cell !== null) {
			$coordinate = $cell->getCoordinate();
			$worksheet = $cell->getWorksheetOrNull();
		}

		$linkURL = ($linkURL === null) ? '' : StringHelper::convertToString(Functions::flattenSingleValue($linkURL));
		$displayName = ($displayName === null) ? '' : Functions::flattenSingleValue($displayName);

		if ((!is_object($cell)) || (trim($linkURL) == '')) {
			return ExcelError::REF();
		}

		$displayName = StringHelper::convertToString($displayName, false);
		if (trim($displayName) === '') {
			$displayName = $linkURL;
		}

		(($nullsafeVariable1 = $worksheet) ? $nullsafeVariable1->getCell($coordinate)->getHyperlink() : null)
			->setUrl($linkURL)
			->setTooltip($displayName)
			->setDisplay('');

		return $displayName;
	}
}
